/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2complements;

import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.modulargolems.compat.materials.l2complements.EnderTeleportGoal;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class EnderTeleportModifier
extends GolemModifier {
    private static final String KEY = "modulargolems:teleport";

    public EnderTeleportModifier() {
        super(StatFilterType.HEALTH, 1);
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        int seconds = (Integer)MGConfig.COMMON.teleportCooldown.get() / 20;
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{seconds}).m_130940_(ChatFormatting.GREEN));
    }

    @Override
    public void onRegisterGoals(AbstractGolemEntity<?, ?> entity, int lv, BiConsumer<Integer, Goal> addGoal) {
        addGoal.accept(10, new EnderTeleportGoal(entity));
    }

    @Override
    public void onAttacked(AbstractGolemEntity<?, ?> entity, LivingAttackEvent event, int level) {
        if (event.getSource().m_269533_(L2DamageTypes.MAGIC)) {
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            event.setCanceled(true);
        }
        if (!EnderTeleportModifier.mayTeleport(entity)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            if (!EnderTeleportModifier.teleport(entity)) continue;
            event.setCanceled(true);
            EnderTeleportModifier.resetCooldown(entity);
            return;
        }
    }

    public static boolean mayTeleport(AbstractGolemEntity<?, ?> entity) {
        long time = entity.getPersistentData().m_128454_(KEY);
        long current = entity.m_9236_().m_46467_();
        return current >= time + (long)((Integer)MGConfig.COMMON.teleportCooldown.get()).intValue();
    }

    public static void resetCooldown(AbstractGolemEntity<?, ?> entity) {
        entity.getPersistentData().m_128356_(KEY, entity.m_9236_().m_46467_());
    }

    public static boolean teleportTowards(AbstractGolemEntity<?, ?> entity, Entity pTarget) {
        return EnderTeleportModifier.teleport(entity, pTarget.m_20185_(), pTarget.m_20186_(), pTarget.m_20189_());
    }

    private static boolean teleport(AbstractGolemEntity<?, ?> entity) {
        int r = (Integer)MGConfig.COMMON.teleportRadius.get();
        if (!entity.m_9236_().m_5776_() && entity.m_6084_()) {
            double d0 = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * (double)r * 2.0;
            double d1 = entity.m_20186_() + (double)(entity.m_217043_().m_188503_(r * 2) - r);
            double d2 = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * (double)r * 2.0;
            return EnderTeleportModifier.teleport(entity, d0, d1, d2);
        }
        return false;
    }

    public static boolean teleport(AbstractGolemEntity<?, ?> entity, double pX, double pY, double pZ) {
        BlockPos.MutableBlockPos ipos = new BlockPos.MutableBlockPos(pX, pY, pZ);
        while (ipos.m_123342_() > entity.m_9236_().m_141937_() && !entity.m_9236_().m_8055_((BlockPos)ipos).m_280555_()) {
            ipos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = entity.m_9236_().m_8055_((BlockPos)ipos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport(entity, (double)pX, (double)pY, (double)pZ);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = entity.m_20182_();
            boolean flag2 = entity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                entity.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_(entity));
                if (!entity.m_20067_()) {
                    entity.m_9236_().m_6263_(null, entity.f_19854_, entity.f_19855_, entity.f_19856_, SoundEvents.f_11852_, entity.m_5720_(), 1.0f, 1.0f);
                    entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }
}

